package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum RuleMode implements Enum {

    @JsonProperty("audit")
    AUDIT("audit", "1"),

    @JsonProperty("auditAndNotify")
    AUDIT_AND_NOTIFY("auditAndNotify", "2"),

    @JsonProperty("enforce")
    ENFORCE("enforce", "3"),

    @JsonProperty("pendingDeletion")
    PENDING_DELETION("pendingDeletion", "4"),

    @JsonProperty("test")
    TEST("test", "5");

    private final String name;
    private final String value;

    private RuleMode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
