package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum RoutingPolicy implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("noMissedCall")
    NO_MISSED_CALL("noMissedCall", "1"),

    @JsonProperty("disableForwardingExceptPhone")
    DISABLE_FORWARDING_EXCEPT_PHONE("disableForwardingExceptPhone", "2"),

    @JsonProperty("disableForwarding")
    DISABLE_FORWARDING("disableForwarding", "3"),

    @JsonProperty("preferSkypeForBusiness")
    PREFER_SKYPE_FOR_BUSINESS("preferSkypeForBusiness", "5"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "6");

    private final String name;
    private final String value;

    private RoutingPolicy(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
