package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum RoleSummaryStatus implements Enum {

    @JsonProperty("ok")
    OK("ok", "0"),

    @JsonProperty("bad")
    BAD("bad", "1");

    private final String name;
    private final String value;

    private RoleSummaryStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
