package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum RiskEventType implements Enum {

    @JsonProperty("unlikelyTravel")
    UNLIKELY_TRAVEL("unlikelyTravel", "0"),

    @JsonProperty("anonymizedIPAddress")
    ANONYMIZED_IPADDRESS("anonymizedIPAddress", "1"),

    @JsonProperty("maliciousIPAddress")
    MALICIOUS_IPADDRESS("maliciousIPAddress", "2"),

    @JsonProperty("unfamiliarFeatures")
    UNFAMILIAR_FEATURES("unfamiliarFeatures", "3"),

    @JsonProperty("malwareInfectedIPAddress")
    MALWARE_INFECTED_IPADDRESS("malwareInfectedIPAddress", "4"),

    @JsonProperty("suspiciousIPAddress")
    SUSPICIOUS_IPADDRESS("suspiciousIPAddress", "5"),

    @JsonProperty("leakedCredentials")
    LEAKED_CREDENTIALS("leakedCredentials", "6"),

    @JsonProperty("investigationsThreatIntelligence")
    INVESTIGATIONS_THREAT_INTELLIGENCE("investigationsThreatIntelligence", "7"),

    @JsonProperty("generic")
    GENERIC("generic", "8"),

    @JsonProperty("adminConfirmedUserCompromised")
    ADMIN_CONFIRMED_USER_COMPROMISED("adminConfirmedUserCompromised", "9"),

    @JsonProperty("mcasImpossibleTravel")
    MCAS_IMPOSSIBLE_TRAVEL("mcasImpossibleTravel", "10"),

    @JsonProperty("mcasSuspiciousInboxManipulationRules")
    MCAS_SUSPICIOUS_INBOX_MANIPULATION_RULES("mcasSuspiciousInboxManipulationRules", "11"),

    @JsonProperty("investigationsThreatIntelligenceSigninLinked")
    INVESTIGATIONS_THREAT_INTELLIGENCE_SIGNIN_LINKED("investigationsThreatIntelligenceSigninLinked", "12"),

    @JsonProperty("maliciousIPAddressValidCredentialsBlockedIP")
    MALICIOUS_IPADDRESS_VALID_CREDENTIALS_BLOCKED_IP("maliciousIPAddressValidCredentialsBlockedIP", "13"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "14");

    private final String name;
    private final String value;

    private RiskEventType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
