package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum RiskDetail implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("adminGeneratedTemporaryPassword")
    ADMIN_GENERATED_TEMPORARY_PASSWORD("adminGeneratedTemporaryPassword", "1"),

    @JsonProperty("userPerformedSecuredPasswordChange")
    USER_PERFORMED_SECURED_PASSWORD_CHANGE("userPerformedSecuredPasswordChange", "2"),

    @JsonProperty("userPerformedSecuredPasswordReset")
    USER_PERFORMED_SECURED_PASSWORD_RESET("userPerformedSecuredPasswordReset", "3"),

    @JsonProperty("adminConfirmedSigninSafe")
    ADMIN_CONFIRMED_SIGNIN_SAFE("adminConfirmedSigninSafe", "4"),

    @JsonProperty("aiConfirmedSigninSafe")
    AI_CONFIRMED_SIGNIN_SAFE("aiConfirmedSigninSafe", "5"),

    @JsonProperty("userPassedMFADrivenByRiskBasedPolicy")
    USER_PASSED_MFADRIVEN_BY_RISK_BASED_POLICY("userPassedMFADrivenByRiskBasedPolicy", "6"),

    @JsonProperty("adminDismissedAllRiskForUser")
    ADMIN_DISMISSED_ALL_RISK_FOR_USER("adminDismissedAllRiskForUser", "7"),

    @JsonProperty("adminConfirmedSigninCompromised")
    ADMIN_CONFIRMED_SIGNIN_COMPROMISED("adminConfirmedSigninCompromised", "8"),

    @JsonProperty("hidden")
    HIDDEN("hidden", "9"),

    @JsonProperty("adminConfirmedUserCompromised")
    ADMIN_CONFIRMED_USER_COMPROMISED("adminConfirmedUserCompromised", "10"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "11");

    private final String name;
    private final String value;

    private RiskDetail(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
