package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ResultantAppStateDetail implements Enum {

    @JsonProperty("noAdditionalDetails")
    NO_ADDITIONAL_DETAILS("noAdditionalDetails", "0"),

    @JsonProperty("dependencyFailedToInstall")
    DEPENDENCY_FAILED_TO_INSTALL("dependencyFailedToInstall", "1"),

    @JsonProperty("dependencyWithRequirementsNotMet")
    DEPENDENCY_WITH_REQUIREMENTS_NOT_MET("dependencyWithRequirementsNotMet", "2"),

    @JsonProperty("dependencyPendingReboot")
    DEPENDENCY_PENDING_REBOOT("dependencyPendingReboot", "3"),

    @JsonProperty("dependencyWithAutoInstallDisabled")
    DEPENDENCY_WITH_AUTO_INSTALL_DISABLED("dependencyWithAutoInstallDisabled", "4"),

    @JsonProperty("seeInstallErrorCode")
    SEE_INSTALL_ERROR_CODE("seeInstallErrorCode", "2000"),

    @JsonProperty("autoInstallDisabled")
    AUTO_INSTALL_DISABLED("autoInstallDisabled", "3000"),

    @JsonProperty("seeUninstallErrorCode")
    SEE_UNINSTALL_ERROR_CODE("seeUninstallErrorCode", "4000"),

    @JsonProperty("pendingReboot")
    PENDING_REBOOT("pendingReboot", "5000"),

    @JsonProperty("installingDependencies")
    INSTALLING_DEPENDENCIES("installingDependencies", "5001"),

    @JsonProperty("contentDownloaded")
    CONTENT_DOWNLOADED("contentDownloaded", "5002"),

    @JsonProperty("powerShellScriptRequirementNotMet")
    POWER_SHELL_SCRIPT_REQUIREMENT_NOT_MET("powerShellScriptRequirementNotMet", "-1013"),

    @JsonProperty("registryRequirementNotMet")
    REGISTRY_REQUIREMENT_NOT_MET("registryRequirementNotMet", "-1012"),

    @JsonProperty("fileSystemRequirementNotMet")
    FILE_SYSTEM_REQUIREMENT_NOT_MET("fileSystemRequirementNotMet", "-1011"),

    @JsonProperty("platformNotApplicable")
    PLATFORM_NOT_APPLICABLE("platformNotApplicable", "-1006"),

    @JsonProperty("minimumCpuSpeedNotMet")
    MINIMUM_CPU_SPEED_NOT_MET("minimumCpuSpeedNotMet", "-1005"),

    @JsonProperty("minimumLogicalProcessorCountNotMet")
    MINIMUM_LOGICAL_PROCESSOR_COUNT_NOT_MET("minimumLogicalProcessorCountNotMet", "-1004"),

    @JsonProperty("minimumPhysicalMemoryNotMet")
    MINIMUM_PHYSICAL_MEMORY_NOT_MET("minimumPhysicalMemoryNotMet", "-1003"),

    @JsonProperty("minimumOsVersionNotMet")
    MINIMUM_OS_VERSION_NOT_MET("minimumOsVersionNotMet", "-1002"),

    @JsonProperty("minimumDiskSpaceNotMet")
    MINIMUM_DISK_SPACE_NOT_MET("minimumDiskSpaceNotMet", "-1001"),

    @JsonProperty("processorArchitectureNotApplicable")
    PROCESSOR_ARCHITECTURE_NOT_APPLICABLE("processorArchitectureNotApplicable", "-1000");

    private final String name;
    private final String value;

    private ResultantAppStateDetail(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
