package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum RestrictionAction implements Enum {

    @JsonProperty("warn")
    WARN("warn", "0"),

    @JsonProperty("audit")
    AUDIT("audit", "1"),

    @JsonProperty("block")
    BLOCK("block", "2");

    private final String name;
    private final String value;

    private RestrictionAction(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
