package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum RestrictedAppsState implements Enum {

    @JsonProperty("prohibitedApps")
    PROHIBITED_APPS("prohibitedApps", "0"),

    @JsonProperty("notApprovedApps")
    NOT_APPROVED_APPS("notApprovedApps", "1");

    private final String name;
    private final String value;

    private RestrictedAppsState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
