package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ReplyRestriction implements Enum {

    @JsonProperty("everyone")
    EVERYONE("everyone", "0"),

    @JsonProperty("authorAndModerators")
    AUTHOR_AND_MODERATORS("authorAndModerators", "1"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "2");

    private final String name;
    private final String value;

    private ReplyRestriction(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
