package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum RegistrationAuthMethod implements Enum {

    @JsonProperty("email")
    EMAIL("email", "0"),

    @JsonProperty("mobilePhone")
    MOBILE_PHONE("mobilePhone", "1"),

    @JsonProperty("officePhone")
    OFFICE_PHONE("officePhone", "2"),

    @JsonProperty("securityQuestion")
    SECURITY_QUESTION("securityQuestion", "3"),

    @JsonProperty("appNotification")
    APP_NOTIFICATION("appNotification", "4"),

    @JsonProperty("appCode")
    APP_CODE("appCode", "5"),

    @JsonProperty("alternateMobilePhone")
    ALTERNATE_MOBILE_PHONE("alternateMobilePhone", "6"),

    @JsonProperty("fido")
    FIDO("fido", "7"),

    @JsonProperty("appPassword")
    APP_PASSWORD("appPassword", "8"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "9");

    private final String name;
    private final String value;

    private RegistrationAuthMethod(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
