package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ReferenceAttachmentProvider implements Enum {

    @JsonProperty("other")
    OTHER("other", "0"),

    @JsonProperty("oneDriveBusiness")
    ONE_DRIVE_BUSINESS("oneDriveBusiness", "1"),

    @JsonProperty("oneDriveConsumer")
    ONE_DRIVE_CONSUMER("oneDriveConsumer", "2"),

    @JsonProperty("dropbox")
    DROPBOX("dropbox", "3");

    private final String name;
    private final String value;

    private ReferenceAttachmentProvider(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
