package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ReferenceAttachmentPermission implements Enum {

    @JsonProperty("other")
    OTHER("other", "0"),

    @JsonProperty("view")
    VIEW("view", "1"),

    @JsonProperty("edit")
    EDIT("edit", "2"),

    @JsonProperty("anonymousView")
    ANONYMOUS_VIEW("anonymousView", "3"),

    @JsonProperty("anonymousEdit")
    ANONYMOUS_EDIT("anonymousEdit", "4"),

    @JsonProperty("organizationView")
    ORGANIZATION_VIEW("organizationView", "5"),

    @JsonProperty("organizationEdit")
    ORGANIZATION_EDIT("organizationEdit", "6");

    private final String name;
    private final String value;

    private ReferenceAttachmentPermission(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
