package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum RecurrenceRangeType implements Enum {

    @JsonProperty("endDate")
    END_DATE("endDate", "0"),

    @JsonProperty("noEnd")
    NO_END("noEnd", "1"),

    @JsonProperty("numbered")
    NUMBERED("numbered", "2");

    private final String name;
    private final String value;

    private RecurrenceRangeType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
