package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum RecurrencePatternType implements Enum {

    @JsonProperty("daily")
    DAILY("daily", "0"),

    @JsonProperty("weekly")
    WEEKLY("weekly", "1"),

    @JsonProperty("absoluteMonthly")
    ABSOLUTE_MONTHLY("absoluteMonthly", "2"),

    @JsonProperty("relativeMonthly")
    RELATIVE_MONTHLY("relativeMonthly", "3"),

    @JsonProperty("absoluteYearly")
    ABSOLUTE_YEARLY("absoluteYearly", "4"),

    @JsonProperty("relativeYearly")
    RELATIVE_YEARLY("relativeYearly", "5");

    private final String name;
    private final String value;

    private RecurrencePatternType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
