package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum RecordCompletionReason implements Enum {

    @JsonProperty("operationCanceled")
    OPERATION_CANCELED("operationCanceled", "0"),

    @JsonProperty("stopToneDetected")
    STOP_TONE_DETECTED("stopToneDetected", "1"),

    @JsonProperty("maxRecordDurationReached")
    MAX_RECORD_DURATION_REACHED("maxRecordDurationReached", "2"),

    @JsonProperty("initialSilenceTimeout")
    INITIAL_SILENCE_TIMEOUT("initialSilenceTimeout", "3"),

    @JsonProperty("maxSilenceTimeout")
    MAX_SILENCE_TIMEOUT("maxSilenceTimeout", "4"),

    @JsonProperty("playPromptFailed")
    PLAY_PROMPT_FAILED("playPromptFailed", "5"),

    @JsonProperty("playBeepFailed")
    PLAY_BEEP_FAILED("playBeepFailed", "6"),

    @JsonProperty("mediaReceiveTimeout")
    MEDIA_RECEIVE_TIMEOUT("mediaReceiveTimeout", "7"),

    @JsonProperty("unspecifiedError")
    UNSPECIFIED_ERROR("unspecifiedError", "8");

    private final String name;
    private final String value;

    private RecordCompletionReason(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
