package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum RatingUnitedStatesTelevisionType implements Enum {

    @JsonProperty("allAllowed")
    ALL_ALLOWED("allAllowed", "0"),

    @JsonProperty("allBlocked")
    ALL_BLOCKED("allBlocked", "1"),

    @JsonProperty("childrenAll")
    CHILDREN_ALL("childrenAll", "2"),

    @JsonProperty("childrenAbove7")
    CHILDREN_ABOVE7("childrenAbove7", "3"),

    @JsonProperty("general")
    GENERAL("general", "4"),

    @JsonProperty("parentalGuidance")
    PARENTAL_GUIDANCE("parentalGuidance", "5"),

    @JsonProperty("childrenAbove14")
    CHILDREN_ABOVE14("childrenAbove14", "6"),

    @JsonProperty("adults")
    ADULTS("adults", "7");

    private final String name;
    private final String value;

    private RatingUnitedStatesTelevisionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
