package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum RatingUnitedStatesMoviesType implements Enum {

    @JsonProperty("allAllowed")
    ALL_ALLOWED("allAllowed", "0"),

    @JsonProperty("allBlocked")
    ALL_BLOCKED("allBlocked", "1"),

    @JsonProperty("general")
    GENERAL("general", "2"),

    @JsonProperty("parentalGuidance")
    PARENTAL_GUIDANCE("parentalGuidance", "3"),

    @JsonProperty("parentalGuidance13")
    PARENTAL_GUIDANCE13("parentalGuidance13", "4"),

    @JsonProperty("restricted")
    RESTRICTED("restricted", "5"),

    @JsonProperty("adults")
    ADULTS("adults", "6");

    private final String name;
    private final String value;

    private RatingUnitedStatesMoviesType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
