package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum RatingUnitedKingdomMoviesType implements Enum {

    @JsonProperty("allAllowed")
    ALL_ALLOWED("allAllowed", "0"),

    @JsonProperty("allBlocked")
    ALL_BLOCKED("allBlocked", "1"),

    @JsonProperty("general")
    GENERAL("general", "2"),

    @JsonProperty("universalChildren")
    UNIVERSAL_CHILDREN("universalChildren", "3"),

    @JsonProperty("parentalGuidance")
    PARENTAL_GUIDANCE("parentalGuidance", "4"),

    @JsonProperty("agesAbove12Video")
    AGES_ABOVE12VIDEO("agesAbove12Video", "5"),

    @JsonProperty("agesAbove12Cinema")
    AGES_ABOVE12CINEMA("agesAbove12Cinema", "6"),

    @JsonProperty("agesAbove15")
    AGES_ABOVE15("agesAbove15", "7"),

    @JsonProperty("adults")
    ADULTS("adults", "8");

    private final String name;
    private final String value;

    private RatingUnitedKingdomMoviesType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
