package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum RatingFranceTelevisionType implements Enum {

    @JsonProperty("allAllowed")
    ALL_ALLOWED("allAllowed", "0"),

    @JsonProperty("allBlocked")
    ALL_BLOCKED("allBlocked", "1"),

    @JsonProperty("agesAbove10")
    AGES_ABOVE10("agesAbove10", "2"),

    @JsonProperty("agesAbove12")
    AGES_ABOVE12("agesAbove12", "3"),

    @JsonProperty("agesAbove16")
    AGES_ABOVE16("agesAbove16", "4"),

    @JsonProperty("agesAbove18")
    AGES_ABOVE18("agesAbove18", "5");

    private final String name;
    private final String value;

    private RatingFranceTelevisionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
