package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum RatingCanadaTelevisionType implements Enum {

    @JsonProperty("allAllowed")
    ALL_ALLOWED("allAllowed", "0"),

    @JsonProperty("allBlocked")
    ALL_BLOCKED("allBlocked", "1"),

    @JsonProperty("children")
    CHILDREN("children", "2"),

    @JsonProperty("childrenAbove8")
    CHILDREN_ABOVE8("childrenAbove8", "3"),

    @JsonProperty("general")
    GENERAL("general", "4"),

    @JsonProperty("parentalGuidance")
    PARENTAL_GUIDANCE("parentalGuidance", "5"),

    @JsonProperty("agesAbove14")
    AGES_ABOVE14("agesAbove14", "6"),

    @JsonProperty("agesAbove18")
    AGES_ABOVE18("agesAbove18", "7");

    private final String name;
    private final String value;

    private RatingCanadaTelevisionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
