package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum RatingAppsType implements Enum {

    @JsonProperty("allAllowed")
    ALL_ALLOWED("allAllowed", "0"),

    @JsonProperty("allBlocked")
    ALL_BLOCKED("allBlocked", "1"),

    @JsonProperty("agesAbove4")
    AGES_ABOVE4("agesAbove4", "2"),

    @JsonProperty("agesAbove9")
    AGES_ABOVE9("agesAbove9", "3"),

    @JsonProperty("agesAbove12")
    AGES_ABOVE12("agesAbove12", "4"),

    @JsonProperty("agesAbove17")
    AGES_ABOVE17("agesAbove17", "5");

    private final String name;
    private final String value;

    private RatingAppsType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
