package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum PropertyType implements Enum {

    @JsonProperty("String")
    STRING("String", "0"),

    @JsonProperty("Int64")
    INT64("Int64", "1"),

    @JsonProperty("Double")
    DOUBLE("Double", "2"),

    @JsonProperty("DateTime")
    DATE_TIME("DateTime", "3"),

    @JsonProperty("Boolean")
    BOOLEAN("Boolean", "4"),

    @JsonProperty("StringCollection")
    STRING_COLLECTION("StringCollection", "5"),

    @JsonProperty("Int64Collection")
    INT64COLLECTION("Int64Collection", "6"),

    @JsonProperty("DoubleCollection")
    DOUBLE_COLLECTION("DoubleCollection", "7"),

    @JsonProperty("DateTimeCollection")
    DATE_TIME_COLLECTION("DateTimeCollection", "8");

    private final String name;
    private final String value;

    private PropertyType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
