package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum PrinterProcessingStateReason implements Enum {

    @JsonProperty("paused")
    PAUSED("paused", "0"),

    @JsonProperty("disconnected")
    DISCONNECTED("disconnected", "1"),

    @JsonProperty("mediaJam")
    MEDIA_JAM("mediaJam", "2"),

    @JsonProperty("mediaNeeded")
    MEDIA_NEEDED("mediaNeeded", "3"),

    @JsonProperty("mediaLow")
    MEDIA_LOW("mediaLow", "4"),

    @JsonProperty("mediaEmpty")
    MEDIA_EMPTY("mediaEmpty", "5"),

    @JsonProperty("coverOpen")
    COVER_OPEN("coverOpen", "6"),

    @JsonProperty("interlockOpen")
    INTERLOCK_OPEN("interlockOpen", "7"),

    @JsonProperty("queueFull")
    QUEUE_FULL("queueFull", "8"),

    @JsonProperty("outputTrayMissing")
    OUTPUT_TRAY_MISSING("outputTrayMissing", "9"),

    @JsonProperty("outputAreaFull")
    OUTPUT_AREA_FULL("outputAreaFull", "10"),

    @JsonProperty("markerSupplyLow")
    MARKER_SUPPLY_LOW("markerSupplyLow", "11"),

    @JsonProperty("markerSupplyEmpty")
    MARKER_SUPPLY_EMPTY("markerSupplyEmpty", "12"),

    @JsonProperty("inputTrayMissing")
    INPUT_TRAY_MISSING("inputTrayMissing", "13"),

    @JsonProperty("outputAlmostFull")
    OUTPUT_ALMOST_FULL("outputAlmostFull", "14"),

    @JsonProperty("markerWasteAlmostFull")
    MARKER_WASTE_ALMOST_FULL("markerWasteAlmostFull", "15"),

    @JsonProperty("markerWasteFull")
    MARKER_WASTE_FULL("markerWasteFull", "16"),

    @JsonProperty("fuserOverTemp")
    FUSER_OVER_TEMP("fuserOverTemp", "17"),

    @JsonProperty("fuserUnderTemp")
    FUSER_UNDER_TEMP("fuserUnderTemp", "18"),

    @JsonProperty("other")
    OTHER("other", "19"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "20");

    private final String name;
    private final String value;

    private PrinterProcessingStateReason(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
