package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum PrinterFeedDirection implements Enum {

    @JsonProperty("longEdgeFirst")
    LONG_EDGE_FIRST("longEdgeFirst", "0"),

    @JsonProperty("shortEdgeFirst")
    SHORT_EDGE_FIRST("shortEdgeFirst", "1");

    private final String name;
    private final String value;

    private PrinterFeedDirection(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
