package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum PrintTaskProcessingState implements Enum {

    @JsonProperty("pending")
    PENDING("pending", "0"),

    @JsonProperty("processing")
    PROCESSING("processing", "1"),

    @JsonProperty("completed")
    COMPLETED("completed", "2"),

    @JsonProperty("aborted")
    ABORTED("aborted", "3"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private PrintTaskProcessingState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
