package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum PrintMediaType implements Enum {

    @JsonProperty("stationery")
    STATIONERY("stationery", "0"),

    @JsonProperty("transparency")
    TRANSPARENCY("transparency", "1"),

    @JsonProperty("envelope")
    ENVELOPE("envelope", "2"),

    @JsonProperty("envelopePlain")
    ENVELOPE_PLAIN("envelopePlain", "3"),

    @JsonProperty("continuous")
    CONTINUOUS("continuous", "4"),

    @JsonProperty("screen")
    SCREEN("screen", "5"),

    @JsonProperty("screenPaged")
    SCREEN_PAGED("screenPaged", "6"),

    @JsonProperty("continuousLong")
    CONTINUOUS_LONG("continuousLong", "7"),

    @JsonProperty("continuousShort")
    CONTINUOUS_SHORT("continuousShort", "8"),

    @JsonProperty("envelopeWindow")
    ENVELOPE_WINDOW("envelopeWindow", "9"),

    @JsonProperty("multiPartForm")
    MULTI_PART_FORM("multiPartForm", "10"),

    @JsonProperty("multiLayer")
    MULTI_LAYER("multiLayer", "11"),

    @JsonProperty("labels")
    LABELS("labels", "12");

    private final String name;
    private final String value;

    private PrintMediaType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
