package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum PrintJobProcessingState implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("pending")
    PENDING("pending", "1"),

    @JsonProperty("pendingHeld")
    PENDING_HELD("pendingHeld", "2"),

    @JsonProperty("processing")
    PROCESSING("processing", "3"),

    @JsonProperty("paused")
    PAUSED("paused", "4"),

    @JsonProperty("stopped")
    STOPPED("stopped", "5"),

    @JsonProperty("completed")
    COMPLETED("completed", "6"),

    @JsonProperty("canceled")
    CANCELED("canceled", "7"),

    @JsonProperty("aborted")
    ABORTED("aborted", "8");

    private final String name;
    private final String value;

    private PrintJobProcessingState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
