package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum PrintFinishing implements Enum {

    @JsonProperty("none")
    NONE("none", "3"),

    @JsonProperty("staple")
    STAPLE("staple", "4"),

    @JsonProperty("punch")
    PUNCH("punch", "5"),

    @JsonProperty("cover")
    COVER("cover", "6"),

    @JsonProperty("bind")
    BIND("bind", "7"),

    @JsonProperty("saddleStitch")
    SADDLE_STITCH("saddleStitch", "8"),

    @JsonProperty("stitchEdge")
    STITCH_EDGE("stitchEdge", "9"),

    @JsonProperty("stapleTopLeft")
    STAPLE_TOP_LEFT("stapleTopLeft", "20"),

    @JsonProperty("stapleBottomLeft")
    STAPLE_BOTTOM_LEFT("stapleBottomLeft", "21"),

    @JsonProperty("stapleTopRight")
    STAPLE_TOP_RIGHT("stapleTopRight", "22"),

    @JsonProperty("stapleBottomRight")
    STAPLE_BOTTOM_RIGHT("stapleBottomRight", "23"),

    @JsonProperty("stitchLeftEdge")
    STITCH_LEFT_EDGE("stitchLeftEdge", "24"),

    @JsonProperty("stitchTopEdge")
    STITCH_TOP_EDGE("stitchTopEdge", "25"),

    @JsonProperty("stitchRightEdge")
    STITCH_RIGHT_EDGE("stitchRightEdge", "26"),

    @JsonProperty("stitchBottomEdge")
    STITCH_BOTTOM_EDGE("stitchBottomEdge", "27"),

    @JsonProperty("stapleDualLeft")
    STAPLE_DUAL_LEFT("stapleDualLeft", "28"),

    @JsonProperty("stapleDualTop")
    STAPLE_DUAL_TOP("stapleDualTop", "29"),

    @JsonProperty("stapleDualRight")
    STAPLE_DUAL_RIGHT("stapleDualRight", "30"),

    @JsonProperty("stapleDualBottom")
    STAPLE_DUAL_BOTTOM("stapleDualBottom", "31"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "32");

    private final String name;
    private final String value;

    private PrintFinishing(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
