package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum PrintDuplexMode implements Enum {

    @JsonProperty("flipOnLongEdge")
    FLIP_ON_LONG_EDGE("flipOnLongEdge", "0"),

    @JsonProperty("flipOnShortEdge")
    FLIP_ON_SHORT_EDGE("flipOnShortEdge", "1"),

    @JsonProperty("oneSided")
    ONE_SIDED("oneSided", "2");

    private final String name;
    private final String value;

    private PrintDuplexMode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
