package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum PrintDuplexConfiguration implements Enum {

    @JsonProperty("twoSidedLongEdge")
    TWO_SIDED_LONG_EDGE("twoSidedLongEdge", "0"),

    @JsonProperty("twoSidedShortEdge")
    TWO_SIDED_SHORT_EDGE("twoSidedShortEdge", "1"),

    @JsonProperty("oneSided")
    ONE_SIDED("oneSided", "2");

    private final String name;
    private final String value;

    private PrintDuplexConfiguration(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
