package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum PrintColorConfiguration implements Enum {

    @JsonProperty("blackAndWhite")
    BLACK_AND_WHITE("blackAndWhite", "0"),

    @JsonProperty("grayscale")
    GRAYSCALE("grayscale", "1"),

    @JsonProperty("color")
    COLOR("color", "2"),

    @JsonProperty("auto")
    AUTO("auto", "3");

    private final String name;
    private final String value;

    private PrintColorConfiguration(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
