package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum PrereleaseFeatures implements Enum {

    @JsonProperty("userDefined")
    USER_DEFINED("userDefined", "0"),

    @JsonProperty("settingsOnly")
    SETTINGS_ONLY("settingsOnly", "1"),

    @JsonProperty("settingsAndExperimentations")
    SETTINGS_AND_EXPERIMENTATIONS("settingsAndExperimentations", "2"),

    @JsonProperty("notAllowed")
    NOT_ALLOWED("notAllowed", "3");

    private final String name;
    private final String value;

    private PrereleaseFeatures(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
