package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum PowerActionType implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("noAction")
    NO_ACTION("noAction", "1"),

    @JsonProperty("sleep")
    SLEEP("sleep", "2"),

    @JsonProperty("hibernate")
    HIBERNATE("hibernate", "3"),

    @JsonProperty("shutdown")
    SHUTDOWN("shutdown", "4");

    private final String name;
    private final String value;

    private PowerActionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
