package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum PolicyPlatformType implements Enum {

    @JsonProperty("android")
    ANDROID("android", "0"),

    @JsonProperty("androidForWork")
    ANDROID_FOR_WORK("androidForWork", "1"),

    @JsonProperty("iOS")
    I_OS("iOS", "2"),

    @JsonProperty("macOS")
    MAC_OS("macOS", "3"),

    @JsonProperty("windowsPhone81")
    WINDOWS_PHONE81("windowsPhone81", "4"),

    @JsonProperty("windows81AndLater")
    WINDOWS81AND_LATER("windows81AndLater", "5"),

    @JsonProperty("windows10AndLater")
    WINDOWS10AND_LATER("windows10AndLater", "6"),

    @JsonProperty("androidWorkProfile")
    ANDROID_WORK_PROFILE("androidWorkProfile", "7"),

    @JsonProperty("windows10XProfile")
    WINDOWS10XPROFILE("windows10XProfile", "8"),

    @JsonProperty("all")
    ALL("all", "100");

    private final String name;
    private final String value;

    private PolicyPlatformType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
