package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum Platform implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("ios")
    IOS("ios", "1"),

    @JsonProperty("android")
    ANDROID("android", "2"),

    @JsonProperty("windows")
    WINDOWS("windows", "3"),

    @JsonProperty("windowsMobile")
    WINDOWS_MOBILE("windowsMobile", "4"),

    @JsonProperty("macOS")
    MAC_OS("macOS", "5");

    private final String name;
    private final String value;

    private Platform(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
