package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum PhysicalAddressType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("home")
    HOME("home", "1"),

    @JsonProperty("business")
    BUSINESS("business", "2"),

    @JsonProperty("other")
    OTHER("other", "3");

    private final String name;
    private final String value;

    private PhysicalAddressType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
