package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum PhoneType implements Enum {

    @JsonProperty("home")
    HOME("home", "0"),

    @JsonProperty("business")
    BUSINESS("business", "1"),

    @JsonProperty("mobile")
    MOBILE("mobile", "2"),

    @JsonProperty("other")
    OTHER("other", "3"),

    @JsonProperty("assistant")
    ASSISTANT("assistant", "4"),

    @JsonProperty("homeFax")
    HOME_FAX("homeFax", "5"),

    @JsonProperty("businessFax")
    BUSINESS_FAX("businessFax", "6"),

    @JsonProperty("otherFax")
    OTHER_FAX("otherFax", "7"),

    @JsonProperty("pager")
    PAGER("pager", "8"),

    @JsonProperty("radio")
    RADIO("radio", "9");

    private final String name;
    private final String value;

    private PhoneType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
