package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum PermissionType implements Enum {

    @JsonProperty("application")
    APPLICATION("application", "1"),

    @JsonProperty("delegated")
    DELEGATED("delegated", "2"),

    @JsonProperty("delegatedUserConsentable")
    DELEGATED_USER_CONSENTABLE("delegatedUserConsentable", "3");

    private final String name;
    private final String value;

    private PermissionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
