package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum PerfectForwardSecrecyGroup implements Enum {

    @JsonProperty("pfs1")
    PFS1("pfs1", "0"),

    @JsonProperty("pfs2")
    PFS2("pfs2", "1"),

    @JsonProperty("pfs2048")
    PFS2048("pfs2048", "2"),

    @JsonProperty("ecp256")
    ECP256("ecp256", "3"),

    @JsonProperty("ecp384")
    ECP384("ecp384", "4"),

    @JsonProperty("pfsMM")
    PFS_MM("pfsMM", "5"),

    @JsonProperty("pfs24")
    PFS24("pfs24", "6");

    private final String name;
    private final String value;

    private PerfectForwardSecrecyGroup(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
