package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum OpenIdConnectResponseTypes implements Enum {

    @JsonProperty("code")
    CODE("code", "1"),

    @JsonProperty("id_token")
    ID_TOKEN("id_token", "2"),

    @JsonProperty("token")
    TOKEN("token", "4");

    private final String name;
    private final String value;

    private OpenIdConnectResponseTypes(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
