package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum OfficeUpdateChannel implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("current")
    CURRENT("current", "1"),

    @JsonProperty("deferred")
    DEFERRED("deferred", "2"),

    @JsonProperty("firstReleaseCurrent")
    FIRST_RELEASE_CURRENT("firstReleaseCurrent", "3"),

    @JsonProperty("firstReleaseDeferred")
    FIRST_RELEASE_DEFERRED("firstReleaseDeferred", "4"),

    @JsonProperty("monthlyEnterprise")
    MONTHLY_ENTERPRISE("monthlyEnterprise", "5");

    private final String name;
    private final String value;

    private OfficeUpdateChannel(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
