package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum OfficeProductId implements Enum {

    @JsonProperty("o365ProPlusRetail")
    O365PRO_PLUS_RETAIL("o365ProPlusRetail", "0"),

    @JsonProperty("o365BusinessRetail")
    O365BUSINESS_RETAIL("o365BusinessRetail", "1"),

    @JsonProperty("visioProRetail")
    VISIO_PRO_RETAIL("visioProRetail", "2"),

    @JsonProperty("projectProRetail")
    PROJECT_PRO_RETAIL("projectProRetail", "3");

    private final String name;
    private final String value;

    private OfficeProductId(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
