package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum NotificationTemplateBrandingOptions implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("includeCompanyLogo")
    INCLUDE_COMPANY_LOGO("includeCompanyLogo", "1"),

    @JsonProperty("includeCompanyName")
    INCLUDE_COMPANY_NAME("includeCompanyName", "2"),

    @JsonProperty("includeContactInformation")
    INCLUDE_CONTACT_INFORMATION("includeContactInformation", "4"),

    @JsonProperty("includeCompanyPortalLink")
    INCLUDE_COMPANY_PORTAL_LINK("includeCompanyPortalLink", "8");

    private final String name;
    private final String value;

    private NotificationTemplateBrandingOptions(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
