package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum NetworkType implements Enum {

    @JsonProperty("intranet")
    INTRANET("intranet", "0"),

    @JsonProperty("extranet")
    EXTRANET("extranet", "1"),

    @JsonProperty("namedNetwork")
    NAMED_NETWORK("namedNetwork", "2"),

    @JsonProperty("trusted")
    TRUSTED("trusted", "3"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private NetworkType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
