package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum Mutability implements Enum {

    @JsonProperty("ReadWrite")
    READ_WRITE("ReadWrite", "0"),

    @JsonProperty("ReadOnly")
    READ_ONLY("ReadOnly", "1"),

    @JsonProperty("Immutable")
    IMMUTABLE("Immutable", "2"),

    @JsonProperty("WriteOnly")
    WRITE_ONLY("WriteOnly", "3");

    private final String name;
    private final String value;

    private Mutability(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
