package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum Modality implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("audio")
    AUDIO("audio", "1"),

    @JsonProperty("video")
    VIDEO("video", "2"),

    @JsonProperty("videoBasedScreenSharing")
    VIDEO_BASED_SCREEN_SHARING("videoBasedScreenSharing", "3"),

    @JsonProperty("data")
    DATA("data", "4"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "5");

    private final String name;
    private final String value;

    private Modality(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
