package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum MobileThreatPartnerTenantState implements Enum {

    @JsonProperty("unavailable")
    UNAVAILABLE("unavailable", "0"),

    @JsonProperty("available")
    AVAILABLE("available", "1"),

    @JsonProperty("enabled")
    ENABLED("enabled", "2"),

    @JsonProperty("unresponsive")
    UNRESPONSIVE("unresponsive", "3");

    private final String name;
    private final String value;

    private MobileThreatPartnerTenantState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
