package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum MobileAppIntent implements Enum {

    @JsonProperty("available")
    AVAILABLE("available", "0"),

    @JsonProperty("notAvailable")
    NOT_AVAILABLE("notAvailable", "1"),

    @JsonProperty("requiredInstall")
    REQUIRED_INSTALL("requiredInstall", "2"),

    @JsonProperty("requiredUninstall")
    REQUIRED_UNINSTALL("requiredUninstall", "3"),

    @JsonProperty("requiredAndAvailableInstall")
    REQUIRED_AND_AVAILABLE_INSTALL("requiredAndAvailableInstall", "4"),

    @JsonProperty("availableInstallWithoutEnrollment")
    AVAILABLE_INSTALL_WITHOUT_ENROLLMENT("availableInstallWithoutEnrollment", "5"),

    @JsonProperty("exclude")
    EXCLUDE("exclude", "6");

    private final String name;
    private final String value;

    private MobileAppIntent(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
