package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum MiracastChannel implements Enum {

    @JsonProperty("userDefined")
    USER_DEFINED("userDefined", "0"),

    @JsonProperty("one")
    ONE("one", "1"),

    @JsonProperty("two")
    TWO("two", "2"),

    @JsonProperty("three")
    THREE("three", "3"),

    @JsonProperty("four")
    FOUR("four", "4"),

    @JsonProperty("five")
    FIVE("five", "5"),

    @JsonProperty("six")
    SIX("six", "6"),

    @JsonProperty("seven")
    SEVEN("seven", "7"),

    @JsonProperty("eight")
    EIGHT("eight", "8"),

    @JsonProperty("nine")
    NINE("nine", "9"),

    @JsonProperty("ten")
    TEN("ten", "10"),

    @JsonProperty("eleven")
    ELEVEN("eleven", "11"),

    @JsonProperty("thirtySix")
    THIRTY_SIX("thirtySix", "36"),

    @JsonProperty("forty")
    FORTY("forty", "40"),

    @JsonProperty("fortyFour")
    FORTY_FOUR("fortyFour", "44"),

    @JsonProperty("fortyEight")
    FORTY_EIGHT("fortyEight", "48"),

    @JsonProperty("oneHundredFortyNine")
    ONE_HUNDRED_FORTY_NINE("oneHundredFortyNine", "149"),

    @JsonProperty("oneHundredFiftyThree")
    ONE_HUNDRED_FIFTY_THREE("oneHundredFiftyThree", "153"),

    @JsonProperty("oneHundredFiftySeven")
    ONE_HUNDRED_FIFTY_SEVEN("oneHundredFiftySeven", "157"),

    @JsonProperty("oneHundredSixtyOne")
    ONE_HUNDRED_SIXTY_ONE("oneHundredSixtyOne", "161"),

    @JsonProperty("oneHundredSixtyFive")
    ONE_HUNDRED_SIXTY_FIVE("oneHundredSixtyFive", "165");

    private final String name;
    private final String value;

    private MiracastChannel(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
