package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum MicrosoftStoreForBusinessLicenseType implements Enum {

    @JsonProperty("offline")
    OFFLINE("offline", "0"),

    @JsonProperty("online")
    ONLINE("online", "1");

    private final String name;
    private final String value;

    private MicrosoftStoreForBusinessLicenseType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
